USE ZamowieniaPrzyklad;
GO

CREATE VIEW R04_stan_zamieszkania_klientow
AS
SELECT DISTINCT StanZamKlienta
FROM Klienci ;
GO

CREATE VIEW R04_informacje_o_pracownikach
AS
SELECT Pracownicy.*
FROM Pracownicy ;
GO

CREATE VIEW R04_lista_cen_produktow
AS
SELECT NazwaProduktu, CenaDetaliczna
FROM Produkty ;
GO

CREATE VIEW R04_siedziby_dostawcow
AS
SELECT     TOP 100 PERCENT MiastoDostawcy, NazwaDostawcy
FROM         Dostawcy
ORDER BY MiastoDostawcy;
GO

CREATE VIEW R04_nazwy_dostawcow
AS
SELECT NazwaDostawcy
FROM Dostawcy ;
GO

CREATE VIEW R05_skorygowane_ceny_hurtowe
AS
SELECT NumerProduktu, CenaHurtowa, CenaHurtowa - (CenaHurtowa * 0.05) AS NowaCena
FROM Dostawcy_produktow ;
GO

CREATE VIEW CH05_Zamowienia_By_Customer_And_Date
AS
SELECT     TOP 100 PERCENT IDKlienta, DataZamowienia, NumerZamowienia
FROM         Zamowienia
ORDER BY IDKlienta, DataZamowienia DESC, NumerZamowienia;
GO

CREATE VIEW R05_wartosc_magazynowa_produktu
AS
SELECT NazwaProduktu, CenaDetaliczna * StanMagazynowy AS InventoryValue
FROM Produkty ;
GO

CREATE VIEW R05_analiza_czasu_realizacji
AS
SELECT NumerZamowienia, DataZamowienia, DataWysylki, DateDiff(d, DataZamowienia, DataWysylki) AS DaysElapsed
FROM Zamowienia ;
GO

CREATE VIEW R05_adresy_dostawcow
AS
SELECT     TOP 100 PERCENT NazwaDostawcy, AdresDostawcy + ', ' + MiastoDostawcy + '  ' + StanSiedzDostawcy + '  ' + KodPocztowyDostawcy AS VendCompleteAddress, 
                      TelefonDostawcy
FROM         Dostawcy
ORDER BY NazwaDostawcy;
GO

CREATE VIEW R06_dostawcy_z_Ballard_Bellevue_Redmond
AS
SELECT     TOP 100 PERCENT NazwaDostawcy, MiastoDostawcy
FROM         Dostawcy
WHERE     (MiastoDostawcy IN ('Ballard', 'Bellevue', 'Redmond'))
ORDER BY NazwaDostawcy;
GO

CREATE VIEW R06_zamowienia_klienta_1001
AS
SELECT NumerZamowienia, IDKlienta
FROM Zamowienia
WHERE IDKlienta = 1001 ;
GO

CREATE VIEW R06_produkty_kosztujace_ponad_125
AS
SELECT     TOP 100 PERCENT NazwaProduktu, CenaDetaliczna
FROM         Produkty
WHERE     (CenaDetaliczna >= 125)
ORDER BY NazwaProduktu;
GO

CREATE VIEW R06_produkty_zawierajace_slowo_DOG
AS
SELECT     TOP 100 PERCENT NazwaProduktu
FROM         Produkty
WHERE     (NazwaProduktu LIKE 'Dog%')
ORDER BY NazwaProduktu;
GO

CREATE VIEW R06_dostawcy_bez_strony_internetowej
AS
SELECT     TOP 100 PERCENT NazwaDostawcy, StronaInterDostawcy
FROM         Dostawcy
WHERE     (StronaInterDostawcy IS NULL)
ORDER BY NazwaDostawcy;
GO

CREATE VIEW R08_klienci_i_daty_zamowien
AS
SELECT     TOP 100 PERCENT Klienci.ImieKlienta + ' ' + Klienci.NazwiskoKlienta AS Klient, Zamowienia.DataZamowienia
FROM         Klienci INNER JOIN
                      Zamowienia ON Klienci.IDKlienta = Zamowienia.IDKlienta
ORDER BY Zamowienia.DataZamowienia;
GO

CREATE VIEW R08_klienci_ktorzy_kupili_rower_i_kask
AS
SELECT     KlienciRowery.ImieKlienta, KlienciRowery.NazwiskoKlienta
FROM         (SELECT DISTINCT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
              FROM          ((Klienci 
                              INNER JOIN Zamowienia 
                              ON Klienci.IDKlienta = Zamowienia.IDKlienta) 
                              INNER JOIN Dane_zamowien 
                              ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia) 
                              INNER JOIN Produkty 
                              ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
              WHERE      Produkty.NazwaProduktu LIKE 'Rower%') KlienciRowery 
        INNER JOIN
             (SELECT DISTINCT Klienci.IDKlienta
              FROM          ((Klienci 
                              INNER JOIN Zamowienia 
                              ON Klienci.IDKlienta = Zamowienia.IDKlienta) 
                              INNER JOIN Dane_zamowien 
                              ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)                                 INNER JOIN Produkty 
                              ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
              WHERE      Produkty.NazwaProduktu LIKE 'Kask%') KlienciKaski 
        ON KlienciRowery.IDKlienta = KlienciKaski.IDKlienta;
GO

CREATE VIEW R08_klienci_i_pracownicy_z_tych_samych_miast
AS
SELECT Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika, Pracownicy.MiastoPracownika
FROM Klienci INNER JOIN Pracownicy ON (Klienci.MiastoKlienta = Pracownicy.MiastoPracownika) ;
GO

CREATE VIEW R08_klienci_i_pracownicy_o_tym_samym_nazwisku
AS
SELECT (Klienci.ImieKlienta + ' ' + Klienci.NazwiskoKlienta) AS Klient, (Pracownicy.ImiePracownika + ' ' + Pracownicy.NazwiskoPracownika) AS Pracownik
FROM Klienci INNER JOIN Pracownicy ON (Klienci.NazwiskoKlienta = Pracownicy.NazwiskoPracownika) ;
GO

CREATE VIEW R08_klienci_ktorzy_zamowili_kaski
AS
SELECT DISTINCT Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM ((Klienci INNER JOIN Zamowienia ON (Klienci.IDKlienta = Zamowienia.IDKlienta)) INNER JOIN Dane_zamowien ON (Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)) INNER JOIN Produkty ON (Produkty.NumerProduktu = Dane_zamowien.NumerProduktu)
WHERE Produkty.NazwaProduktu LIKE 'Kask%%' ;
GO

CREATE VIEW R08_pracownicy_i_klienci
AS
SELECT DISTINCT (Pracownicy.ImiePracownika + ' ' + Pracownicy.NazwiskoPracownika) AS Pracownik, (Klienci.ImieKlienta + ' ' + Klienci.NazwiskoKlienta) AS Klient
FROM (Pracownicy INNER JOIN Zamowienia ON (Pracownicy.IDPracownika = Zamowienia.IDPracownika)) INNER JOIN Klienci ON (Klienci.IDKlienta = Zamowienia.IDKlienta) ;
GO

CREATE VIEW R08_zamowienia_z_podzialem_na_produkty
AS
SELECT     TOP 100 PERCENT Zamowienia.NumerZamowienia AS NrZamowienia, Zamowienia.DataZamowienia, Dane_zamowien.NumerProduktu AS NrProduktu, 
                      Produkty.NazwaProduktu AS Produkt, Dane_zamowien.CenaZakupu AS Cena, Dane_zamowien.ZamowionaIlosc AS Ilosc, 
                      Dane_zamowien.CenaZakupu * Dane_zamowien.ZamowionaIlosc AS Wartosc
FROM         Zamowienia INNER JOIN
                      Dane_zamowien ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia INNER JOIN
                      Produkty ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
ORDER BY NrZamowienia;
GO

CREATE VIEW R08_produkty_i_kategorie
AS
SELECT Kategorie.OpisKategorii, Produkty.NazwaProduktu
FROM Kategorie INNER JOIN Produkty ON (Kategorie.IDKategorii = Produkty.IDKategorii) ;
GO

CREATE VIEW CH08_Dostawcy_And_Produkty_Less_Than_100
AS
SELECT Dostawcy.NazwaDostawcy, Produkty.NazwaProduktu, Dostawcy_produktow.CenaHurtowa
FROM (Dostawcy INNER JOIN Dostawcy_produktow ON (Dostawcy.IDDostawcy = Dostawcy_produktow.IDDostawcy)) INNER JOIN Produkty ON (Produkty.NumerProduktu = Dostawcy_produktow.NumerProduktu)
WHERE Dostawcy_produktow.CenaHurtowa < 100 ;
GO

CREATE VIEW R08_dostawcy_i_produkty_tansze_niz_100
AS
SELECT     Klienci.ImieKlienta + ' ' + Klienci.NazwiskoKlienta AS Klient, RD.DataZamowienia, RD.NazwaProduktu, RD.ZamowionaIlosc, 
                      RD.CenaZakupu
FROM         Klienci LEFT OUTER JOIN
             (SELECT     Zamowienia.IDKlienta, Zamowienia.DataZamowienia, Produkty.NazwaProduktu, Dane_zamowien.ZamowionaIlosc, Dane_zamowien.CenaZakupu
              FROM          ((Zamowienia 
              INNER JOIN      Dane_zamowien 
              ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
              INNER JOIN      Produkty 
              ON Dane_zamowien.NumerProduktu = Produkty.NumerProduktu) 
              INNER JOIN      Kategorie 
              ON Kategorie.IDKategorii = Produkty.IDKategorii
              WHERE      Kategorie.OpisKategorii = 'Rowery') RD 
             ON Klienci.IDKlienta = RD.IDKlienta;
GO

CREATE VIEW R09_wszystkie_produkty_dowolne_daty_zamowien
AS
SELECT     Produkty.NumerProduktu, Produkty.NazwaProduktu, OD.DataZamowienia
FROM         Produkty LEFT OUTER JOIN
             (SELECT DISTINCT Dane_zamowien.NumerProduktu, Zamowienia.DataZamowienia
              FROM          Zamowienia 
              INNER JOIN    Dane_zamowien 
              ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia) OD 
             ON Produkty.NumerProduktu = OD.NumerProduktu;
GO

CREATE VIEW R09_klienci_ktorzy_nie_kupili_kasku
AS
SELECT     Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM         Klienci LEFT OUTER JOIN
               (SELECT     Zamowienia.IDKlienta, Produkty.NazwaProduktu
                FROM          Produkty 
                INNER JOIN    (Zamowienia 
                INNER JOIN    Dane_zamowien 
                ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia) 
                ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
                WHERE      Produkty.NazwaProduktu LIKE '%kask%') ZamKask 
            ON Klienci.IDKlienta = ZamKask.IDKlienta
WHERE     (ZamKask.IDKlienta IS NULL);
GO

CREATE VIEW R09_klienci_bez_sprzedawcy_z_tym_samym_kodem
AS
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Klienci.KodPocztowyKlienta
FROM Klienci LEFT JOIN Pracownicy ON (Klienci.KodPocztowyKlienta = Pracownicy.KodPocztowyPracownika)
WHERE Pracownicy.IDPracownika Is Null ;
GO

CREATE VIEW R09_produkty_nigdy_nie_zamawiane
AS
SELECT Produkty.NumerProduktu, Produkty.NazwaProduktu
FROM Produkty LEFT JOIN Dane_zamowien ON (Produkty.NumerProduktu = Dane_zamowien.NumerProduktu)
WHERE Dane_zamowien.NumerZamowienia Is Null ;
GO

CREATE VIEW R10_klienci_na_kaski_i_dostawcy_kaskow
AS
SELECT     Klienci.NazwiskoKlienta + ', ' + Klienci.ImieKlienta AS FullName, Produkty.NazwaProduktu, 'Klient' AS IDWiersza
FROM         ((Klienci INNER JOIN
                      Zamowienia ON (Klienci.IDKlienta = Zamowienia.IDKlienta)) INNER JOIN
                      Dane_zamowien ON (Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)) INNER JOIN
                      Produkty ON (Produkty.NumerProduktu = Dane_zamowien.NumerProduktu)
WHERE     Produkty.NazwaProduktu LIKE '%kask%'
UNION
SELECT     Dostawcy.NazwaDostawcy, Produkty.NazwaProduktu, 'Dostawca' AS IDWiersza
FROM         (Dostawcy INNER JOIN
                      Dostawcy_produktow ON (Dostawcy.IDDostawcy = Dostawcy_produktow.IDDostawcy)) INNER JOIN
                      Produkty ON (Produkty.NumerProduktu = Dostawcy_produktow.NumerProduktu)
WHERE     Produkty.NazwaProduktu LIKE '%kask%';
GO

CREATE VIEW R10_klienci_zamowili_rowery_UNION_klienci_zamowili_kaski
AS
SELECT     Klienci.ImieKlienta, Klienci.NazwiskoKlienta, 'Rower' AS TypProduktu
FROM         ((Klienci INNER JOIN
                      Zamowienia ON (Klienci.IDKlienta = Zamowienia.IDKlienta)) INNER JOIN
                      Dane_zamowien ON (Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)) INNER JOIN
                      Produkty ON (Produkty.NumerProduktu = Dane_zamowien.NumerProduktu)
WHERE     Produkty.NazwaProduktu LIKE '%rower%'
UNION
SELECT     Klienci.ImieKlienta, Klienci.NazwiskoKlienta, 'Kask' AS TypProduktu
FROM         ((Klienci INNER JOIN
                      Zamowienia ON (Klienci.IDKlienta = Zamowienia.IDKlienta)) INNER JOIN
                      Dane_zamowien ON (Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)) INNER JOIN
                      Produkty ON (Produkty.NumerProduktu = Dane_zamowien.NumerProduktu)
WHERE     Produkty.NazwaProduktu LIKE '%kask%';
GO

CREATE VIEW R10_klienci_ktorzy_zamowili_rowery_lub_kaski
AS
SELECT DISTINCT Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM ((Klienci INNER JOIN Zamowienia ON (Klienci.IDKlienta = Zamowienia.IDKlienta)) INNER JOIN Dane_zamowien ON (Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)) INNER JOIN Produkty ON (Produkty.NumerProduktu = Dane_zamowien.NumerProduktu)
WHERE Produkty.NazwaProduktu LIKE '%rower%' OR Produkty.NazwaProduktu LIKE '%kask%' ;
GO

CREATE VIEW R10_klienci_UNION_ALL_pracownicy
AS
SELECT     TOP 100 PERCENT *
FROM         (SELECT     Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Klienci.AdresKlienta, Klienci.MiastoKlienta, Klienci.StanZamKlienta, 
                                              Klienci.KodPocztowyKlienta
                       FROM          Klienci
                       UNION ALL
                       SELECT     Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika, Pracownicy.AdresPracownika, Pracownicy.MiastoPracownika, Pracownicy.StanZamPracownika, 
                                             Pracownicy.KodPocztowyPracownika
                       FROM         Pracownicy) DERIVEDTBL
ORDER BY KodPocztowyKlienta;
GO

CREATE VIEW R11_klienci_ktorzy_kupili_odziez_albo_akcesoria
AS
SELECT     IDKlienta, ImieKlienta, NazwiskoKlienta
FROM         Klienci
WHERE     (IDKlienta = ANY
                          (SELECT     Zamowienia.IDKlienta
                            FROM          ((Zamowienia INNER JOIN
                                                   Dane_zamowien ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia) INNER JOIN
                                                   Produkty ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu) INNER JOIN
                                                   Kategorie ON Kategorie.IDKategorii = Produkty.IDKategorii
                            WHERE      Kategorie.OpisKategorii = 'Odzież' OR
                                                   Kategorie.OpisKategorii = 'Akcesoria'));
GO

CREATE VIEW R11_klienci_ktorzy_kupili_odziez_albo_akcesoria_EXISTS
AS
SELECT     IDKlienta, ImieKlienta, NazwiskoKlienta
FROM         dbo.Klienci
WHERE     EXISTS
                          (SELECT     *
                            FROM          ((Zamowienia INNER JOIN
                                                   Dane_zamowien ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia) INNER JOIN
                                                   Produkty ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu) INNER JOIN
                                                   Kategorie ON Kategorie.IDKategorii = Produkty.IDKategorii
                            WHERE      (Kategorie.OpisKategorii = 'Odzież' OR
                                                   Kategorie.OpisKategorii = 'Akcesoria') AND Klienci.IDKlienta = Zamowienia.IDKlienta);
GO

CREATE VIEW R11_klienci_ktorzy_kupili_odziez_albo_akcesoria_IN
AS
SELECT     IDKlienta, ImieKlienta, NazwiskoKlienta
FROM         dbo.Klienci
WHERE     (IDKlienta IN
                          (SELECT     Zamowienia.IDKlienta
                            FROM          ((Zamowienia INNER JOIN
                                                   Dane_zamowien ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia) INNER JOIN
                                                   Produkty ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu) INNER JOIN
                                                   Kategorie ON Kategorie.IDKategorii = Produkty.IDKategorii
                            WHERE      Kategorie.OpisKategorii = 'Odzież' OR
                                                   Kategorie.OpisKategorii = 'Akcesoria'));
GO

CREATE VIEW R11_klienci_ktorzy_zamowili_rowery_EXISTS
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE EXISTS
    (SELECT *
    FROM (Zamowienia
    INNER JOIN Dane_zamowien
    ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia) 
    INNER JOIN Produkty
    ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
    WHERE Produkty.IDKategorii = 2
    AND Zamowienia.IDKlienta = Klienci.IDKlienta);
GO

CREATE VIEW R11_klienci_ktorzy_zamowili_rowery_IN
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE Klienci.IDKlienta IN 
(SELECT Zamowienia.IDKlienta FROM ((Zamowienia 
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia) 
INNER JOIN Produkty
ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu) 
INNER JOIN Kategorie
ON Kategorie.IDKategorii = Produkty.IDKategorii 
WHERE Kategorie.OpisKategorii = 'Rowery');
GO

CREATE VIEW R11_klienci_ktorzy_zamowili_rowery_JOIN
AS 
SELECT DISTINCT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM ((Klienci
INNER JOIN Zamowienia
ON Klienci.IDKlienta=Zamowienia.IDKlienta)
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia=Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Produkty.NumerProduktu=Dane_zamowien.NumerProduktu
WHERE Produkty.IDKategorii=2;
GO

CREATE VIEW R11_daty_ostatnich_zamowien_produktow
AS
SELECT Produkty.NumerProduktu, Produkty.NazwaProduktu, (SELECT max(Zamowienia.DataZamowienia) FROM Zamowienia INNER JOIN Dane_zamowien ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia WHERE Dane_zamowien.NumerProduktu = Produkty.NumerProduktu) AS LastOrder
FROM Produkty ;
GO

CREATE VIEW R11_produkty_nigdy_nie_zamawiane
AS
SELECT Produkty.NazwaProduktu
FROM Produkty
WHERE Produkty.NumerProduktu NOT IN (SELECT Dane_zamowien.NumerProduktu FROM Dane_zamowien) ;
GO

CREATE VIEW R11_liczba_produktow_oferowanych_przez_dostawcow
AS
SELECT NazwaDostawcy, (SELECT count(*) FROM Dostawcy_produktow WHERE Dostawcy_produktow.IDDostawcy = Dostawcy.IDDostawcy) AS LiczbaProduktowDostawcy
FROM Dostawcy ;
GO

CREATE VIEW R12_srednia_cena_roweru_gorskiego
AS
SELECT avg(CenaDetaliczna) AS SredniaCena
FROM Produkty
WHERE NazwaProduktu LIKE '%Rower górski%' ;
GO

CREATE VIEW R12_data_najnowszego_zamowienia
AS
SELECT max(DataZamowienia) AS NajnowszeZamowienie
FROM Zamowienia ;
GO

CREATE VIEW R12_liczba_klientow_z_Kalifornii
AS
SELECT count(*) AS LiczbaKalifornijczykow
FROM Klienci
WHERE StanZamKlienta = 'CA' ;
GO

CREATE VIEW R12_cena_zakupu_a_srednia_cena_detaliczna
AS
SELECT DISTINCT NazwaProduktu, Produkty.NumerProduktu
FROM Produkty INNER JOIN Dane_zamowien ON (Produkty.NumerProduktu =  Dane_zamowien.NumerProduktu)
WHERE Dane_zamowien.CenaZakupu >=     (SELECT avg(CenaDetaliczna)     FROM Produkty) ;
GO

CREATE VIEW R12_calkowita_wartosc_zamowienia_numer_8
AS
SELECT sum(ZamowionaIlosc * CenaZakupu) AS CalkowitaWartosc
FROM Dane_zamowien
WHERE NumerZamowienia = 8 ;
GO

CREATE VIEW R13_wartosci_zamowien_wg_klienta_i_daty
AS
SELECT Klienci.ImieKlienta +  ' ' +     Klienci.NazwiskoKlienta AS Klient, Zamowienia.DataZamowienia, sum(Dane_zamowien.CenaZakupu *     Dane_zamowien.ZamowionaIlosc) AS CalkowitaWartosc
FROM (Klienci INNER JOIN Zamowienia ON (Klienci.IDKlienta = Zamowienia.IDKlienta)) INNER JOIN Dane_zamowien ON (Zamowienia.NumerZamowienia =     Dane_zamowien.NumerZamowienia)
GROUP BY Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Zamowienia.DataZamowienia ;
GO

CREATE VIEW R13_sprzedaz_wedlug_produktow
AS
SELECT Produkty.NazwaProduktu, sum(Dane_zamowien.CenaZakupu * Dane_zamowien.ZamowionaIlosc) AS LacznaSprzedaz
FROM Produkty INNER JOIN Dane_zamowien ON (Produkty.NumerProduktu = Dane_zamowien.NumerProduktu)
GROUP BY Produkty.NazwaProduktu ;
GO

CREATE VIEW R13_sredni_czas_dostawy
AS
SELECT Dostawcy.NazwaDostawcy, avg(Dostawcy_produktow.TerminDostarczenia) AS SrdCzasDost
FROM Dostawcy INNER JOIN Dostawcy_produktow ON (Dostawcy.IDDostawcy = Dostawcy_produktow.IDDostawcy)
GROUP BY Dostawcy.NazwaDostawcy ;
GO

CREATE VIEW R13_liczba_produktow_od_dostawcow_grupowanie
AS
SELECT Dostawcy.NazwaDostawcy, count(Dostawcy_produktow.NumerProduktu) AS LiczbaProduktow
FROM Dostawcy INNER JOIN Dostawcy_produktow ON (Dostawcy.IDDostawcy = Dostawcy_produktow.IDDostawcy)
GROUP BY Dostawcy.NazwaDostawcy ;
GO

CREATE VIEW R13_liczba_produktow_od_dostawcow_podzapytanie
AS
SELECT NazwaDostawcy, (SELECT count(*) FROM Dostawcy_produktow WHERE Dostawcy_produktow.IDDostawcy = Dostawcy.IDDostawcy) AS LiczbaProduktowDostawcy
FROM Dostawcy ;
GO

CREATE VIEW R13_wartosci_zamowien_wg_klienta_i_daty_GT1000
AS
SELECT Klienci.ImieKlienta +  ' ' +     Klienci.NazwiskoKlienta AS Klient, Zamowienia.DataZamowienia, sum(Dane_zamowien.CenaZakupu *     Dane_zamowien.ZamowionaIlosc) AS CalkowitaWartosc
FROM (Klienci INNER JOIN Zamowienia ON (Klienci.IDKlienta = Zamowienia.IDKlienta)) INNER JOIN Dane_zamowien ON (Zamowienia.NumerZamowienia =     Dane_zamowien.NumerZamowienia)
GROUP BY Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Zamowienia.DataZamowienia
HAVING sum(Dane_zamowien.CenaZakupu * Dane_zamowien.ZamowionaIlosc) > 1000 ;
GO

CREATE VIEW R14_sprzedaz_wg_produktu_wieksza_niz_srednia_w_kategorii
AS
SELECT     Produkty.NazwaProduktu, SUM(Dane_zamowien.CenaZakupu * Dane_zamowien.ZamowionaIlosc) AS LacznaSprzedaz
FROM         Produkty 
INNER JOIN   Dane_zamowien 
  ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
GROUP BY Produkty.IDKategorii, Produkty.NazwaProduktu
HAVING      (SUM(Dane_zamowien.CenaZakupu * Dane_zamowien.ZamowionaIlosc) >
                (SELECT     AVG(SumaKategorii)
                 FROM       
                    (SELECT     P2.IDKategorii, SUM(OD2.CenaZakupu * OD2.ZamowionaIlosc) AS SumaKategorii
                     FROM          Produkty AS P2 
                     INNER JOIN    Dane_zamowien AS OD2 
                       ON P2.NumerProduktu = OD2.NumerProduktu
                     GROUP BY P2.IDKategorii, P2.NumerProduktu) AS S
                 WHERE      S.IDKategorii = Produkty.IDKategorii
                 GROUP BY IDKategorii));
GO

CREATE VIEW R14_liczba_zamowien_na_jeden_produkt
AS
SELECT     COUNT(*) AS LiczbaZamowienPojedynczychProduktow
FROM         (SELECT     Dane_zamowien.NumerZamowienia
                       FROM          Dane_zamowien
                       GROUP BY Dane_zamowien.NumerZamowienia
                       HAVING      COUNT(*) = 1) SingleZamowienia;
GO

CREATE VIEW R14_sredni_czas_dostawy_wiekszy_niz_ogolny_czas_sredni
AS
SELECT Dostawcy.NazwaDostawcy, avg(Dostawcy_produktow.TerminDostarczenia) AS SrdCzasDost
FROM Dostawcy INNER JOIN Dostawcy_produktow ON (Dostawcy.IDDostawcy = Dostawcy_produktow.IDDostawcy)
GROUP BY Dostawcy.NazwaDostawcy
HAVING avg(Dostawcy_produktow.TerminDostarczenia) > (SELECT avg(TerminDostarczenia) FROM Dostawcy_produktow) ;
GO

CREATE VIEW R14_stany_z_Zachodniego_Wybrzeza_duze_zamowienia
AS
SELECT Klienci.StanZamKlienta, sum(Dane_zamowien.ZamowionaIlosc *     Dane_zamowien.CenaZakupu) AS SumOfZamowienia
FROM (Klienci INNER JOIN Zamowienia ON (Klienci.IDKlienta = Zamowienia.IDKlienta)) INNER JOIN Dane_zamowien ON (Zamowienia.NumerZamowienia =     Dane_zamowien.NumerZamowienia)
WHERE Klienci.StanZamKlienta IN ('WA', 'OR', 'CA')
GROUP BY Klienci.StanZamKlienta
HAVING sum(Dane_zamowien.ZamowionaIlosc *     Dane_zamowien.CenaZakupu) > 1000000 ;
GO

CREATE VIEW R18_klienci_ktorzy_kupili_rower_i_kask_EXISTS
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE EXISTS 
(SELECT *
FROM (Zamowienia
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
WHERE Produkty.IDKategorii = 2
AND Zamowienia.IDKlienta = Klienci.IDKlienta)
AND EXISTS
(SELECT *
FROM (Zamowienia
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
WHERE Produkty.NazwaProduktu LIKE 'Kask%'
AND Zamowienia.IDKlienta = Klienci.IDKlienta);
GO

CREATE VIEW R18_klienci_ktorzy_kupili_rowery_ale_nie_kaski_EXISTS
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE EXISTS 
(SELECT *
FROM (Zamowienia
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
WHERE Produkty.IDKategorii = 2
AND Zamowienia.IDKlienta = Klienci.IDKlienta)
AND NOT EXISTS
(SELECT *
FROM (Zamowienia
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
WHERE Produkty.NazwaProduktu LIKE 'Kask%'
AND Zamowienia.IDKlienta = Klienci.IDKlienta);
GO

CREATE VIEW R18_klienci_ktorzy_kupili_rowery_ale_nie_kaski
AS 
SELECT IDKlienta, ImieKlienta, NazwiskoKlienta
FROM Klienci
WHERE (IDKlienta IN
                          (SELECT     Zamowienia.IDKlienta
                            FROM          (Zamowienia
INNER JOIN
                                                   Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN
                                                   Produkty
ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
                            WHERE      Produkty.IDKategorii = 2)) 
          
AND (IDKlienta NOT IN
                          (SELECT     Zamowienia.IDKlienta
                            FROM          (Zamowienia
INNER JOIN
                                                   Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN
                                                   Produkty
ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
                            WHERE      Produkty.NazwaProduktu LIKE 'Kask%'));
GO

CREATE VIEW R18_klienci_na_rower_i_kask_jedno_zamowienie
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Zamowienia.NumerZamowienia, Zamowienia.DataZamowienia
FROM Klienci
INNER JOIN Zamowienia
ON Klienci.IDKlienta=Zamowienia.IDKlienta
WHERE EXISTS  (SELECT * FROM (Zamowienia As O2
INNER JOIN Dane_zamowien
ON O2.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu WHERE Produkty.IDKategorii = 2
AND Zamowienia.IDKlienta = Klienci.IDKlienta
AND O2.NumerZamowienia = Zamowienia.NumerZamowienia)
AND EXISTS (SELECT * FROM (Zamowienia As O3 
INNER JOIN Dane_zamowien
ON O3.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu WHERE Produkty.NazwaProduktu LIKE 'Kask%'
AND Zamowienia.IDKlienta = Klienci.IDKlienta
AND O3.NumerZamowienia = Zamowienia.NumerZamowienia);
GO

CREATE VIEW R18_klienci_bez_zamowien_JOIN
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Klienci.AdresKlienta, Klienci.MiastoKlienta, Klienci.StanZamKlienta
FROM Klienci LEFT JOIN Zamowienia
ON Klienci.IDKlienta=Zamowienia.IDKlienta
WHERE Zamowienia.NumerZamowienia Is Null;
GO

CREATE VIEW R18_klienci_bez_zamowien_NOT_IN
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Klienci.AdresKlienta, Klienci.MiastoKlienta, Klienci.StanZamKlienta
FROM Klienci
WHERE Klienci.IDKlienta NOT IN
(SELECT Zamowienia.IDKlienta FROM Zamowienia);
GO

CREATE VIEW R18_klienci_ktorzy_nie_kupili_rowerow_ani_opon_NOTIN_1
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE Klienci.IDKlienta NOT IN
(SELECT IDKlienta FROM
(Zamowienia
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Dane_zamowien.NumerProduktu = Produkty.NumerProduktu
WHERE Produkty.IDKategorii IN (2, 6));
GO

CREATE VIEW R18_klienci_ktorzy_nie_kupili_rowerow_ani_opon_NOTIN_2
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE Klienci.IDKlienta NOT IN
(SELECT IDKlienta FROM
(Zamowienia
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Dane_zamowien.NumerProduktu = Produkty.NumerProduktu
WHERE Produkty.IDKategorii = 2)
AND Klienci.IDKlienta NOT IN 
(SELECT IDKlienta FROM
(Zamowienia
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Dane_zamowien.NumerProduktu = Produkty.NumerProduktu
WHERE Produkty.IDKategorii = 6);
GO

CREATE VIEW R18_zamowienia_na_rowery_ale_nie_na_kaski_EXISTS
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Zamowienia.NumerZamowienia, Zamowienia.DataZamowienia
FROM Klienci
INNER JOIN Zamowienia
ON Klienci.IDKlienta=Zamowienia.IDKlienta
WHERE EXISTS  (SELECT NumerZamowienia  FROM (Dane_zamowien
INNER JOIN Produkty
ON Dane_zamowien.NumerProduktu = Produkty.NumerProduktu)
INNER JOIN Kategorie
ON Produkty.IDKategorii = Kategorie.IDKategorii WHERE Kategorie.OpisKategorii = 'Rowery'
AND Dane_zamowien.NumerZamowienia = Zamowienia.NumerZamowienia)
AND NOT EXISTS  (SELECT *  FROM Dane_zamowien
INNER JOIN Produkty
ON Dane_zamowien.NumerProduktu = Produkty.NumerProduktu WHERE Produkty.NazwaProduktu LIKE 'Kask%'
AND Dane_zamowien.NumerZamowienia = Zamowienia.NumerZamowienia);
GO

CREATE VIEW R18_dostawcy_akcesoriow_uchwytow_odziezy
AS 
SELECT Dostawcy.IDDostawcy, Dostawcy.NazwaDostawcy
FROM Dostawcy
WHERE Dostawcy.IDDostawcy IN
(SELECT IDDostawcy 
  FROM (Dostawcy_produktow
INNER JOIN Produkty
ON Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu)
INNER JOIN Kategorie
ON Produkty.IDKategorii = Kategorie.IDKategorii
  WHERE Kategorie.OpisKategorii = 'Akcesoria')
AND Dostawcy.IDDostawcy IN
(SELECT IDDostawcy 
  FROM (Dostawcy_produktow
INNER JOIN Produkty
ON Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu)
INNER JOIN Kategorie
ON Produkty.IDKategorii = Kategorie.IDKategorii
  WHERE Kategorie.OpisKategorii = 'Uchwyty samochodowe')
AND Dostawcy.IDDostawcy IN
(SELECT IDDostawcy 
  FROM (Dostawcy_produktow
INNER JOIN Produkty
ON Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu)
INNER JOIN Kategorie
ON Produkty.IDKategorii = Kategorie.IDKategorii
  WHERE Kategorie.OpisKategorii = 'Odzież');
GO

CREATE VIEW R19_klienci_ktorzy_zlozyli_zamowienia_1_tydz_grud_2012
AS
SELECT        IDKlienta, ImieKlienta, NazwiskoKlienta, (CASE WHEN IDKlienta IN
                            (SELECT        IDKlienta
                              FROM            Zamowienia
                              WHERE        DataZamowienia BETWEEN CAST('2012-12-01' AS Date) AND CAST('2012-12-07' AS Date)) 
                            THEN 'Zamawiał' 
                            ELSE 'Nie zamawiał' END) AS ZamPierwTydz2012
FROM            Klienci;
GO

CREATE VIEW R19_nazwy_stanow_zamieszkania_klientow
AS
SELECT        ImieKlienta, NazwiskoKlienta, 
                         (CASE StanZamKlienta WHEN 'TX' THEN 'Teksas' WHEN 'CA' THEN 'Kalifornia' WHEN 'OR' THEN 'Oregon' WHEN 'WA' THEN 'Waszyngton' ELSE 'Unknown' END) 
                         AS NazwaStanuZamKlienta
FROM           Klienci;
GO

CREATE VIEW R19_wiek_pracownikow_na_15lutego2014
AS
SELECT        IDPracownika, ImiePracownika, NazwiskoPracownika, DATEDIFF(yy, DataUrodzPracownika, CAST('2014-02-15' AS Date)) - (CASE WHEN Month(DataUrodzPracownika) 
                         < 2 THEN 0 WHEN Month(DataUrodzPracownika) > 2 THEN 1 WHEN Day(DataUrodzPracownika) > 15 THEN 1 ELSE 0 END) AS WiekPracownika
FROM            Pracownicy;
GO

CREATE VIEW R19_ocena_popytu_na_produkty
AS
SELECT NumerProduktu, NazwaProduktu, 
       (CASE 
        WHEN (SELECT SUM(ZamowionaIlosc)
              FROM   Dane_zamowien
              WHERE  (Dane_zamowien.NumerProduktu = Produkty.NumerProduktu)) <= 200
        THEN 'Mierny' 
        WHEN (SELECT SUM(ZamowionaIlosc)
              FROM   Dane_zamowien
              WHERE  (Dane_zamowien.NumerProduktu = Produkty.NumerProduktu)) <= 500 
        THEN 'Przeciętny' 
        WHEN (SELECT SUM(ZamowionaIlosc)
              FROM   Dane_zamowien
              WHERE  (Dane_zamowien.NumerProduktu = Produkty.NumerProduktu)) <= 1000 
        THEN 'Dobry' 
        ELSE 'Znakomity' END) AS Popyt
FROM            Produkty;
GO

CREATE VIEW R19_produkty_zamawiane_w_grudniu_2012
AS
SELECT        NumerProduktu, NazwaProduktu, (CASE WHEN Produkty.NumerProduktu IN
                             (SELECT        Dane_zamowien.NumerProduktu
                               FROM            Dane_zamowien INNER JOIN
                                                         Zamowienia ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia
                               WHERE        (Zamowienia.DataZamowienia BETWEEN CAST('2012-12-01' AS Date) AND CAST('2012-12-31' AS Date))) THEN 'Zamawiał' ELSE 'Nie zamawiał' END) 
                         AS ZamowionyProdukt
FROM            Produkty;
GO

CREATE VIEW R20_klienci_wszystkie_produkty_info_o_zakupie
AS 
SELECT TOP 100 PERCENT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Klienci.AdresKlienta, 
  Klienci.MiastoKlienta, Klienci.StanZamKlienta, Klienci.KodPocztowyKlienta, Kategorie.OpisKategorii, 
  Produkty.NumerProduktu, Produkty.NazwaProduktu, Produkty.CenaDetaliczna, 
  (CASE WHEN Klienci.IDKlienta IN 
      (SELECT Zamowienia.IDKlienta 
       FROM Zamowienia INNER JOIN Dane_zamowien ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia 
       WHERE Dane_zamowien.NumerProduktu = Produkty.NumerProduktu) 
   THEN 'Kupiłeś to!' ELSE ' ' END) AS ZamowionyProdukt
FROM Klienci, Kategorie
INNER JOIN Produkty
ON Kategorie.IDKategorii=Produkty.IDKategorii
ORDER BY Klienci.IDKlienta, Kategorie.OpisKategorii, Produkty.NumerProduktu;
GO

CREATE VIEW R20_katalog_dla_klientow
AS 
SELECT TOP 100 PERCENT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Klienci.AdresKlienta, 
  Klienci.MiastoKlienta, Klienci.StanZamKlienta, Klienci.KodPocztowyKlienta, Kategorie.OpisKategorii, 
  Produkty.NumerProduktu, Produkty.NazwaProduktu, Produkty.CenaDetaliczna
FROM Klienci, Kategorie
INNER JOIN Produkty
ON Kategorie.IDKategorii=Produkty.IDKategorii
ORDER BY Klienci.IDKlienta, Kategorie.OpisKategorii, Produkty.NumerProduktu;
GO

CREATE VIEW R20_kupony_za_zakupy_w_grudniu_2012
AS 
SELECT ztblKuponyZakupowe.LiczbaKuponow, CustDecWartoscCalkowita.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, 
  Klienci.AdresKlienta, Klienci.MiastoKlienta, Klienci.StanZamKlienta, Klienci.KodPocztowyKlienta, CustDecWartoscCalkowita.Purchase
FROM ztblKuponyZakupowe, Klienci
INNER JOIN (SELECT Zamowienia.IDKlienta, Sum((CenaZakupu)*(ZamowionaIlosc)) AS Purchase FROM Zamowienia
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia=Dane_zamowien.NumerZamowienia WHERE Zamowienia.DataZamowienia Between '2012-12-01'
AND '2012-12-31' GROUP BY Zamowienia.IDKlienta)  AS CustDecWartoscCalkowita
ON Klienci.IDKlienta=CustDecWartoscCalkowita.IDKlienta
WHERE CustDecWartoscCalkowita.Purchase BETWEEN ztblKuponyZakupowe.ProgDolnyZakupu
AND ztblKuponyZakupowe.ProgGornyZakupu;
GO

CREATE VIEW R20_wydruk_kuponow_znizkowych_dla_klientow
AS 
SELECT TOP 100 PERCENT R20_kupony_za_zakupy_w_grudniu_2012.IDKlienta, R20_kupony_za_zakupy_w_grudniu_2012.ImieKlienta, 
  R20_kupony_za_zakupy_w_grudniu_2012.NazwiskoKlienta, R20_kupony_za_zakupy_w_grudniu_2012.AdresKlienta, 
  R20_kupony_za_zakupy_w_grudniu_2012.MiastoKlienta, R20_kupony_za_zakupy_w_grudniu_2012.StanZamKlienta, 
  R20_kupony_za_zakupy_w_grudniu_2012.KodPocztowyKlienta
FROM ztblNumeryKolejne, R20_kupony_za_zakupy_w_grudniu_2012
WHERE R20_kupony_za_zakupy_w_grudniu_2012.LiczbaKuponow >= ztblNumeryKolejne.Kolejnosc
ORDER BY R20_kupony_za_zakupy_w_grudniu_2012.IDKlienta;
GO

CREATE VIEW R20_etykiety_do_korespondencji_z_klientami_z_pominieciem_5
AS 
SELECT TOP 100 PERCENT * 
FROM 
(SELECT ' ' As ImieKlienta, ' ' As NazwiskoKlienta, ' ' As CustStreenAddress, ' ' As MiastoKlienta, ' ' As StanZamKlienta, ' ' As KodPocztowyKlienta 
FROM ztblNumeryKolejne
WHERE ztblNumeryKolejne.Kolejnosc <= 5
UNION ALL SELECT Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Klienci.AdresKlienta, Klienci.MiastoKlienta, Klienci.StanZamKlienta, Klienci.KodPocztowyKlienta
FROM Klienci) As CustLabels
ORDER BY KodPocztowyKlienta, NazwiskoKlienta;
GO

CREATE VIEW R20_pracownicy_i_klienci_z_tego_samego_stanu
AS 
SELECT Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, 
  Klienci.NumKierKlienta, Klienci.TelefonKlienta, 
  (CASE WHEN Klienci.IDKlienta IN (SELECT IDKlienta FROM Zamowienia WHERE Zamowienia.IDPracownika = Pracownicy.IDPracownika) 
        THEN 'Zamawiał from you.' ELSE ' ' END) AS StatusKlienta
FROM Pracownicy, Klienci
WHERE Pracownicy.StanZamPracownika=Klienci.StanZamKlienta;
GO

CREATE VIEW R20_zakresy_cen_produktow
AS 
SELECT ztblZakresyCen.KategoriaCenowa, Produkty.NazwaProduktu, Produkty.CenaDetaliczna
FROM ztblZakresyCen, Produkty
WHERE Produkty.CenaDetaliczna Between ztblZakresyCen.ProgDolny
AND ztblZakresyCen.ProgGorny;
GO

CREATE VIEW R20_sprzedaz_produktow_wszystkie_miesiace_2012_2013
AS 
SELECT ztblMiesiace.MiesiacRok, Produkty.NazwaProduktu, 
  (SELECT Sum(Dane_zamowien.ZamowionaIlosc*Dane_zamowien.CenaZakupu) AS WartoscSprzedazy 
FROM  (Produkty
INNER JOIN Dane_zamowien
ON Produkty.NumerProduktu=Dane_zamowien.NumerProduktu)
INNER JOIN Zamowienia
ON Zamowienia.NumerZamowienia=Dane_zamowien.NumerZamowienia
WHERE Zamowienia.DataZamowienia BETWEEN ztblMiesiace.PoczatekMiesiaca
AND ztblMiesiace.KoniecMiesiaca) AS Sprzedaz
FROM ztblMiesiace, Produkty
WHERE ztblMiesiace.NumerRoku BETWEEN 2012 AND 2013;
GO

CREATE VIEW R20_sprzedaz_miesieczna_z_podzialem_na_produkty
AS 
SELECT ztblMiesiace.MiesiacRok, Produkty.NazwaProduktu, Sum(Dane_zamowien.ZamowionaIlosc*Dane_zamowien.CenaZakupu) AS Sprzedaz
FROM ztblMiesiace, (Produkty
INNER JOIN Dane_zamowien
ON Produkty.NumerProduktu=Dane_zamowien.NumerProduktu)
INNER JOIN Zamowienia
ON Zamowienia.NumerZamowienia=Dane_zamowien.NumerZamowienia
WHERE Zamowienia.DataZamowienia BETWEEN ztblMiesiace.PoczatekMiesiaca
AND ztblMiesiace.KoniecMiesiaca
GROUP BY ztblMiesiace.MiesiacRok, Produkty.NazwaProduktu;
GO

CREATE VIEW R20_sprzedaz_miesieczna_tabelarycznie
AS 
SELECT Produkty.NazwaProduktu, SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Styczen) AS Styczen, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Luty) AS Luty, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Marzec) AS Marzec, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Kwiecien) AS Kwiecien, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Maj) AS Maj, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Czerwiec) AS Czerwiec, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Lipiec) AS Lipiec, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Sierpien) AS Sierpien, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Wrzesien) AS Wrzesien, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Pazdziernik) AS Pazdziernik, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Listopad) AS Listopad, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Grudzien) AS Grudzien
FROM ztblMiesiace, (Produkty
INNER JOIN Dane_zamowien
ON Produkty.NumerProduktu=Dane_zamowien.NumerProduktu)
INNER JOIN Zamowienia
ON Zamowienia.NumerZamowienia=Dane_zamowien.NumerZamowienia
WHERE Zamowienia.DataZamowienia BETWEEN ztblMiesiace.PoczatekMiesiaca
AND ztblMiesiace.KoniecMiesiaca
GROUP BY Produkty.NazwaProduktu;
GO

CREATE VIEW R20_etykiety_produktow_na_stanie
AS 
SELECT TOP 100 PERCENT ztblNumeryKolejne.Kolejnosc, Produkty.NumerProduktu, Produkty.NazwaProduktu
FROM ztblNumeryKolejne, Produkty
WHERE ztblNumeryKolejne.Kolejnosc<=Produkty.StanMagazynowy
ORDER BY Produkty.NumerProduktu, ztblNumeryKolejne.Kolejnosc;
GO
